﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.POSRetail.Helper;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using System.Windows.Threading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for OrderConfirmation.xaml
    /// </summary>
    public partial class OrderConfirmation : Window
    {
        public OrderConfirmation()
        {
            InitializeComponent();
            CalculateCartTotal();
            LoadCurrentOrder();
        }

        private void CalculateCartTotal()
        {
            AppSession.CurrentOrders.SubTotal = (from co in AppSession.CurrentOrders.OrdersDetailsList
                                                 select co).Sum(r => r.Amount);

            lblSubTotal.Text = AppSession.CurrentOrders.SubTotal.ToString("0.00");
            lblDiscount.Text = (AppSession.CurrentOrders.Discount + AppSession.CurrentOrders.HappyHoursDiscount + AppSession.CurrentOrders.TotalDiscount).ToString("0.00");
            lblServiceTax.Text = AppSession.CurrentOrders.ServiceTax.ToString("0.00");
            lblTotal.Text = AppSession.CurrentOrders.Total.ToString("$ 0.00");
            lblTable.Text = AppSession.CurrentOrders.TableNumber.ToString();
        }

        private void LoadCurrentOrder()
        {
            gdOrders.ItemsSource = AppSession.CurrentOrders.OrdersDetailsList;
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void btnSavePending_Click(object sender, RoutedEventArgs e)
        {
            AppSession.CurrentOrders.OrderFrom = AppSession.GetAppSettingsValue("OrdersFrom");
            AppSession.CurrentOrders.UsersAccountID = (AppSession.CurrentUser != null ? AppSession.CurrentUser.UniqueID : Guid.Empty);
            AppSession.CurrentOrders.AdminUserAccountID = (AppSession.CurrentAdminUser != null ? AppSession.CurrentAdminUser.UniqueID : Guid.Empty);
            AppSession.CurrentOrders.IsShipToBillingAddress = true;
            AppSession.CurrentOrders.ShippingOption = "Self Collection";
            AppSession.CurrentOrders.Total = AppSession.CurrentOrders.TotalBeforeGST + AppSession.CurrentOrders.GST + AppSession.CurrentOrders.Shipping;
            AppSession.CurrentOrders.PaymentStatus = "Pending";
            AppSession.CurrentOrders.OrderStatus = "New";

            int days = AppSession.CurrentOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
            AppSession.CurrentOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

            if (OrdersBL.Save(AppSession.CurrentOrders))
            {
                AppSession.CurrentUser = null;
                AppSession.CurrentOrders = null;
                this.Tag = true;
                this.Close();
            }
        }

        private void btnCash_Click(object sender, RoutedEventArgs e)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                Action action = () =>
                {
                    AppSession.CurrentOrders.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;
                    AppSession.CurrentOrders.IsShipToBillingAddress = true;
                    AppSession.CurrentOrders.OrderFrom = AppSession.OrderFrom;
                    AppSession.CurrentOrders.OrderStatus = "Pending";

                    int days = AppSession.CurrentOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
                    AppSession.CurrentOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

                    AppSession.CurrentOrders.PaymentStatus = "Pending";

                    if (OrdersBL.Save(AppSession.CurrentOrders))
                    {
                        OrdersBL.GenerateInvoice(AppSession.CurrentOrders.UniqueID);
                        AppSession.CurrentOrders = OrdersBL.GetItem(AppSession.CurrentOrders.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                    }
                };
                Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
            });

            if (!result.OperationFailed)
            {
                Controls.AddPayment cashpay = new Controls.AddPayment();
                cashpay.Owner = this;
                cashpay.ShowInTaskbar = false;
                cashpay.ShowDialog();
                if (bool.Parse(cashpay.Tag.ToString()))
                {
                    Helper.ReceiptPrintHelper Printer = new Helper.ReceiptPrintHelper();
                    Printer.PrintReceipt(AppSession.CurrentOrders);
                    AppSession.CurrentOrders = null;
                    AppSession.CurrentUser = null;
                    this.Tag = true;
                    this.Close();
                }
            }
            else
                App.ShowMessageBox(result.Error.Message, "Ei8ht POS");
        }

        private void btnCard_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Card");
        }

        private void btnCashAndCard_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Cash & Card");
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private bool ValidateUser()
        {
            if (AppSession.CurrentUser != null)
            {
                return true;
            }
            else
            {
                MessageBox.Show("Please add the Customer Info and try again.", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                return false;
            }
        }

        private void btnAddDesignerInfo_Click(object sender, RoutedEventArgs e)
        {
            Controls.AddDesignerInfo adddesig = new Controls.AddDesignerInfo();
            adddesig.Owner = this;
            adddesig.ShowInTaskbar = false;
            adddesig.ShowDialog();
        }

        private void btnPrintCustomerInvoice_Click(object sender, RoutedEventArgs e)
        {
            ReceiptPrintHelper printObj = new ReceiptPrintHelper();
            printObj.PrintTaxInvoice(AppSession.CurrentOrders);
        }
    }
}
